/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.model;

import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class Node {
    public String id;
    public boolean inheritTransform = true;
    public boolean isAnimated;
    public final Vector3 translation = new Vector3();
    public final Quaternion rotation = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    public final Vector3 scale = new Vector3(1.0f, 1.0f, 1.0f);
    public final Matrix4 localTransform = new Matrix4();
    public final Matrix4 globalTransform = new Matrix4();
    public Array<NodePart> parts = new Array(2);
    protected Node parent;
    private final Array<Node> children = new Array(2);

    public Matrix4 calculateLocalTransform() {
        if (!this.isAnimated) {
            this.localTransform.set(this.translation, this.rotation, this.scale);
        }
        return this.localTransform;
    }

    public Matrix4 calculateWorldTransform() {
        if (this.inheritTransform && this.parent != null) {
            this.globalTransform.set(this.parent.globalTransform).mul(this.localTransform);
        } else {
            this.globalTransform.set(this.localTransform);
        }
        return this.globalTransform;
    }

    public void calculateTransforms(boolean recursive) {
        this.calculateLocalTransform();
        this.calculateWorldTransform();
        if (recursive) {
            for (Node child : this.children) {
                child.calculateTransforms(true);
            }
        }
    }

    public void calculateBoneTransforms(boolean recursive) {
        for (NodePart part : this.parts) {
            if (part.invBoneBindTransforms == null || part.bones == null || part.invBoneBindTransforms.size != part.bones.length) continue;
            int n = part.invBoneBindTransforms.size;
            for (int i = 0; i < n; ++i) {
                part.bones[i].set(((Node[])part.invBoneBindTransforms.keys)[i].globalTransform).mul(((Matrix4[])part.invBoneBindTransforms.values)[i]);
            }
        }
        if (recursive) {
            for (Node child : this.children) {
                child.calculateBoneTransforms(true);
            }
        }
    }

    public BoundingBox calculateBoundingBox(BoundingBox out) {
        out.inf();
        return this.extendBoundingBox(out);
    }

    public BoundingBox calculateBoundingBox(BoundingBox out, boolean transform2) {
        out.inf();
        return this.extendBoundingBox(out, transform2);
    }

    public BoundingBox extendBoundingBox(BoundingBox out) {
        return this.extendBoundingBox(out, true);
    }

    public BoundingBox extendBoundingBox(BoundingBox out, boolean transform2) {
        int partCount = this.parts.size;
        for (int i = 0; i < partCount; ++i) {
            NodePart part = this.parts.get(i);
            if (!part.enabled) continue;
            MeshPart meshPart = part.meshPart;
            if (transform2) {
                meshPart.mesh.extendBoundingBox(out, meshPart.offset, meshPart.size, this.globalTransform);
                continue;
            }
            meshPart.mesh.extendBoundingBox(out, meshPart.offset, meshPart.size);
        }
        int childCount = this.children.size;
        for (int i = 0; i < childCount; ++i) {
            this.children.get(i).extendBoundingBox(out);
        }
        return out;
    }

    public <T extends Node> void attachTo(T parent) {
        parent.addChild((Node)this);
    }

    public void detach() {
        if (this.parent != null) {
            this.parent.removeChild(this);
            this.parent = null;
        }
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size > 0;
    }

    public int getChildCount() {
        return this.children.size;
    }

    public Node getChild(int index2) {
        return this.children.get(index2);
    }

    public Node getChild(String id, boolean recursive, boolean ignoreCase) {
        return Node.getNode(this.children, id, recursive, ignoreCase);
    }

    public <T extends Node> int addChild(T child) {
        return this.insertChild(-1, child);
    }

    public <T extends Node> int addChildren(Iterable<T> nodes2) {
        return this.insertChildren(-1, nodes2);
    }

    public <T extends Node> int insertChild(int index2, T child) {
        Node p;
        for (p = this; p != null; p = p.getParent()) {
            if (p != child) continue;
            throw new GdxRuntimeException("Cannot add a parent as a child");
        }
        p = child.getParent();
        if (p != null && !p.removeChild(child)) {
            throw new GdxRuntimeException("Could not remove child from its current parent");
        }
        if (index2 < 0 || index2 >= this.children.size) {
            index2 = this.children.size;
            this.children.add(child);
        } else {
            this.children.insert(index2, child);
        }
        child.parent = this;
        return index2;
    }

    public <T extends Node> int insertChildren(int index2, Iterable<T> nodes2) {
        if (index2 < 0 || index2 > this.children.size) {
            index2 = this.children.size;
        }
        int i = index2;
        for (Node child : nodes2) {
            this.insertChild(i++, child);
        }
        return index2;
    }

    public <T extends Node> boolean removeChild(T child) {
        if (!this.children.removeValue(child, true)) {
            return false;
        }
        child.parent = null;
        return true;
    }

    public Iterable<Node> getChildren() {
        return this.children;
    }

    public Node getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public Node copy() {
        return new Node().set(this);
    }

    protected Node set(Node other) {
        this.detach();
        this.id = other.id;
        this.isAnimated = other.isAnimated;
        this.inheritTransform = other.inheritTransform;
        this.translation.set(other.translation);
        this.rotation.set(other.rotation);
        this.scale.set(other.scale);
        this.localTransform.set(other.localTransform);
        this.globalTransform.set(other.globalTransform);
        this.parts.clear();
        for (NodePart nodePart : other.parts) {
            this.parts.add(nodePart.copy());
        }
        this.children.clear();
        for (Node child : other.getChildren()) {
            this.addChild(child.copy());
        }
        return this;
    }

    public static Node getNode(Array<Node> nodes2, String id, boolean recursive, boolean ignoreCase) {
        Node node;
        int i;
        int n = nodes2.size;
        if (ignoreCase) {
            for (i = 0; i < n; ++i) {
                node = nodes2.get(i);
                if (!node.id.equalsIgnoreCase(id)) continue;
                return node;
            }
        } else {
            for (i = 0; i < n; ++i) {
                node = nodes2.get(i);
                if (!node.id.equals(id)) continue;
                return node;
            }
        }
        if (recursive) {
            for (i = 0; i < n; ++i) {
                node = Node.getNode(nodes2.get((int)i).children, id, true, ignoreCase);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }
}

